/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import gnu.trove.THashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.Processor;

@Debug.Renderer(text="\"size = \" + size()", hasChildren="!isEmpty()", childrenArray="myMap.entrySet().toArray()")
public class MostlySingularMultiMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 2784473565881807109L;
    protected final Map<K, Object> myMap = this.createMap();
    private static final MostlySingularMultiMap EMPTY = new EmptyMap();

    @NotNull
    protected Map<K, Object> createMap() {
        THashMap tHashMap = new THashMap();
        if (tHashMap == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(0);
        }
        return tHashMap;
    }

    public void add(@NotNull K key, @NotNull V value2) {
        Object current;
        if (key == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(1);
        }
        if (value2 == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(2);
        }
        if ((current = this.myMap.get(key)) == null) {
            this.myMap.put(key, value2);
        } else if (current instanceof ValueList) {
            ValueList curList = (ValueList)current;
            curList.add(value2);
        } else {
            ValueList newList = new ValueList();
            newList.add(current);
            newList.add(value2);
            this.myMap.put(key, newList);
        }
    }

    public boolean processForKey(@NotNull K key, @NotNull Processor<? super V> p) {
        if (key == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(7);
        }
        if (p == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(8);
        }
        return this.processValue(p, this.myMap.get(key));
    }

    private boolean processValue(@NotNull Processor<? super V> p, Object v) {
        if (p == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(9);
        }
        if (v instanceof ValueList) {
            for (Object o : (ValueList)v) {
                if (p.process(o)) continue;
                return false;
            }
        } else if (v != null) {
            return p.process(v);
        }
        return true;
    }

    public boolean processAllValues(@NotNull Processor<? super V> p) {
        if (p == null) {
            MostlySingularMultiMap.$$$reportNull$$$0(10);
        }
        for (Object v : this.myMap.values()) {
            if (this.processValue(p, v)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "{" + StringUtil.join(this.myMap.entrySet(), entry -> {
            Object value2 = entry.getValue();
            String s = (value2 instanceof ValueList ? value2 : Collections.singletonList(value2)).toString();
            return entry.getKey() + ": " + s;
        }, "; ") + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/MostlySingularMultiMap";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createMap";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/MostlySingularMultiMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "rawValueToCollection";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyMap";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "newMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeAllValues";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processForKey";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAllValues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "valuesForKey";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyMap
    extends MostlySingularMultiMap {
        private EmptyMap() {
        }

        public void add(@NotNull Object key, @NotNull Object value2) {
            if (key == null) {
                EmptyMap.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                EmptyMap.$$$reportNull$$$0(1);
            }
            throw new IncorrectOperationException();
        }

        public boolean processForKey(@NotNull Object key, @NotNull Processor p) {
            if (key == null) {
                EmptyMap.$$$reportNull$$$0(6);
            }
            if (p == null) {
                EmptyMap.$$$reportNull$$$0(7);
            }
            return true;
        }

        public boolean processAllValues(@NotNull Processor p) {
            if (p == null) {
                EmptyMap.$$$reportNull$$$0(8);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 11: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 5: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/MostlySingularMultiMap$EmptyMap";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/MostlySingularMultiMap$EmptyMap";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "keySet";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removeAllValues";
                    break;
                }
                case 5: 
                case 11: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processForKey";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "processAllValues";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "valuesForKey";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 5: 
                case 11: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class ValueList<V>
    extends ArrayList<V> {
    }
}

